import platform

# ================= 配置区域 =================

# 1. 目标服务器配置
# 如果是公网服务器，填公网IP；如果是局域网，填内网IP
TARGET_IP = "Your IP address"  # <---【请修改这里】!!!
TARGET_PORT = 9100
TARGET_URL = f"http://{TARGET_IP}:{TARGET_PORT}/metrics"

# 必须与 exporter.py 里的 Token 一致
API_TOKEN = "sre-secret-key-2024"

# 2. 显示配置
REFRESH_RATE = 1.0   # 数据刷新间隔 (秒)
PAGE_SWITCH_SEC = 4  # 页面轮播间隔 (秒)
TIMEOUT = 3          # 请求超时时间

# 3. 硬件与环境检测
# 自动检测是否为 RK3506B (ARM架构)
IS_ARM_BOARD = 'aarch64' in platform.machine() or 'arm' in platform.machine()
USE_EMULATOR = not IS_ARM_BOARD # 不是板子就开模拟器

# 板子 I2C 配置
I2C_PORT = 1
I2C_ADDRESS = 0x3C
