import time
import requests
import config
from display import OledDisplay

def main():
    screen = OledDisplay()
    if not screen.device:
        print("❌ Screen init failed, exiting.")
        return

    print(f"🚀 Monitor Started.")
    print(f"🎯 Target: {config.TARGET_URL}")

    current_page = 0
    PAGE_COUNT = 4
    last_switch = time.time()
    
    # HTTP Header 带上 Token
    headers = {"Authorization": f"Bearer {config.API_TOKEN}"}

    while True:
        try:
            resp = requests.get(config.TARGET_URL, headers=headers, timeout=config.TIMEOUT)
            
            if resp.status_code == 200:
                data = resp.json()
                
                # 翻页逻辑
                if time.time() - last_switch > config.PAGE_SWITCH_SEC:
                    current_page = (current_page + 1) % PAGE_COUNT
                    last_switch = time.time()
                
                # 渲染
                screen.render(data, current_page)
                
                # 终端心跳日志
                n = data.get('net',{})
                print(f"✅ On | CPU:{data['cpu_total']}% | Net: D{n.get('down')}K", end='\r')
                
            elif resp.status_code == 403:
                print("\n🔒 Auth Failed: Token mismatch!")
                screen.draw_offline()
            else:
                print(f"\n❌ Server Error: {resp.status_code}")
                screen.draw_offline()

        except requests.exceptions.RequestException:
            print("⚠️  Network Error / Offline      ", end='\r')
            screen.draw_offline()
        except Exception as e:
            print(f"\n❌ Error: {e}")
            time.sleep(1)

        time.sleep(config.REFRESH_RATE)

if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        print("\n🛑 Stopped.")
