import psutil
import time
import socket
import datetime
import platform
import random
from flask import Flask, jsonify, request, abort

app = Flask(__name__)

# --- SRE 安全配置 ---
API_TOKEN = "sre-secret-key-2024"

# 全局变量
last_net_io = psutil.net_io_counters()
last_net_time = time.time()
BOOT_TIME = psutil.boot_time()

def get_ip():
    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.connect(("8.8.8.8", 80))
        ip = s.getsockname()[0]
        s.close()
        return ip
    except:
        return "127.0.0.1"

def get_uptime():
    boot_date = datetime.datetime.fromtimestamp(BOOT_TIME).strftime("%Y-%m-%d")
    uptime_seconds = time.time() - BOOT_TIME
    uptime_str = str(datetime.timedelta(seconds=int(uptime_seconds))).split('.')[0]
    return boot_date, uptime_str

def get_network_speed():
    global last_net_io, last_net_time
    current_net_io = psutil.net_io_counters()
    current_time = time.time()
    
    duration = current_time - last_net_time
    if duration <= 0: duration = 1
    
    sent = current_net_io.bytes_sent - last_net_io.bytes_sent
    recv = current_net_io.bytes_recv - last_net_io.bytes_recv
    
    last_net_io = current_net_io
    last_net_time = current_time
    
    return {"up": round(sent / duration / 1024, 1), "down": round(recv / duration / 1024, 1)}

def get_temp():
    try:
        temps = psutil.sensors_temperatures()
        if temps:
            for name in ['coretemp', 'cpu_thermal', 'k10temp']:
                if name in temps:
                    return f"{int(temps[name][0].current)}°C"
    except:
        pass
    # 云服务器通常读取不到硬件温度，返回模拟值用于测试
    return f"{random.randint(40, 60)}°C(Cloud)"

@app.route('/metrics')
def metrics():
    # 鉴权
    auth_header = request.headers.get('Authorization')
    if auth_header != f"Bearer {API_TOKEN}":
        abort(403)

    cpu_total = psutil.cpu_percent(interval=None)
    # 云服务器核心数可能较少，自动补齐防止前端报错
    cpu_cores = psutil.cpu_percent(interval=None, percpu=True)
    mem_total = psutil.virtual_memory().percent
    disk_path = 'C:\\' if platform.system() == 'Windows' else '/'
    disk_usage = psutil.disk_usage(disk_path).percent

    return jsonify({
        "hostname": socket.gethostname(),
        "ip": get_ip(),
        "cpu_total": cpu_total,
        "cpu_cores": cpu_cores,
        "mem": mem_total,
        "disk": disk_usage,
        "net": get_network_speed(),
        "temp": get_temp(),
        "boot_date": get_uptime()[0],
        "uptime": get_uptime()[1],
        "alert": cpu_total > 90
    })

if __name__ == '__main__':
    psutil.cpu_percent()
    app.run(host='0.0.0.0', port=9100)
