#!/usr/bin/python3
# collect_task.py - 这是一个专门负责“干活”的脚本
import time
from app import monitor

def run_task():
    print(f"[{time.ctime()}] 开始采集数据...")
    
    # 1. 采集
    data = monitor.collect_system_data()
    
    # 2. 存库
    # 注意：这里需要 monitor.py 里有 save_to_db 函数
    # 如果你之前删了，请去把它加回去！
    if data:
        monitor.save_to_db(data)
        print("✅ 数据采集并入库成功！")
    else:
        print("❌ 采集失败，数据为空")

if __name__ == "__main__":
    run_task()
