关于ServerMonitor项目的错误和纠正记录
记录人：Lonely Horse
日期：2025年12月1日～2025年12月5日
项目阶段：从单一长混合脚本到模块化脚本项目的开发

一.mysql数据库与实际有异
问题
·现象：
服务启动正常，但是api却有问题导致500网络错误
·日志：
反馈mysql报错，说表里面没有拿到数据

原因
·代码：因为创建代码在前，先运行到后面再报的错，虽然脚本执行失败了，但是表已经创建完成了，所以等待第二次启动时，会直接跳过创建表的程序模块，开始写入数据，就会一直报错，以此循环，所以此刻就会只有旧的表列，新的表列无法创建

解决方法
·清理旧表：在mysql里面输入"drop table if exists server_monitor.monitor_log;"
·代码的修改：修改创建表列字段的代码，使其正常运行，与实际的输入数据类型一致
·重启：让脚本再次运行，启动新的建表模块，建立新的数据表

二.端口占用
问题
·现象：启动脚本，但是报错98"地址已在使用"

原因
·z进程：由于上一次脚本占用过端口，尽管我们使用了ctrl+c来停止脚本的运行，但是他是非正常终止，所以最终会有一个僵尸进程停留
·crontab冲突：旧的crontab任务一直在运行，抢占了端口

解决方法
·终止进程：彻底的清除那个旧的z进程，使用
fuser -k 端口/tcp(当然也有可能不是tcp类型)
·修改自动化逻辑；不是定时启动脚本，而是在本地访问接口，使用
curl http://本地ip:PORT/api/data

三.路径和模块的导入发生错误
问题
·现象：
使用nohup就报错没有这个文件或者文件夹
重构目录后，就报错没有找到这个模块

原因
·陷阱：相对路径会影响nohup的启动，导致他找不到我的主脚本的地址，也就无法自动启动脚本
·限制：因为模块只能存在于同一文件夹下，才能运用，他没有像是c语言""寻找头文件那么便利

解决方法
·路径：使用绝对路径，不要使用相对路径，不知道路径的，使用which命令来查找，或者find模糊查询也可以
·PYTHONPATH：明确告诉run脚本，python的根目录在哪里，标注版本也可以，即
export PYTHONPATH=/home/{$(whoami)}/项目

四.隐形字符导致的错误
问题
·现象：代码看着基本没什么问题，但是就是会报错说	SyntaxError: invalid character

原因
·坏习惯：比如说喜欢敲完代码，就空格一下，如果是def行，就会导致模块无法使用，因为这个空格，直接将模块哪本该使用的代码忽视了

解决方法
·使用vim；观察他的报错在第几行，输入：行数，直接跳到该行查看问题
·删除问题：删除空白或者乱码的符号

五.mysql配置问题和语法问题
问题
·字符集错误:utf8被我写成了utf-8，导致连接失败
·规定的格式：大小写有些是固定的，尽管有些指令是不在乎大小写的，比如drop，select等等，但是有些是规定了，比如None，True，False等

总结
python中有些需要大写，必须要熟悉并记住

涉及数据库写入的操作，就必须要有commit

配置参数一定要按照规定，仔细写

我们在上传项目到github上时，有些文件不能一起上传，需要被隐藏，比如涉及个人ip，隐私要素的文件，我们需要一个副本代替，使用".gitigore"忽略原本，以及使用"gitkeep"保存文件夹




